
 
; Temperature Switch using an NTC thermistor

;	ERRORLEVEL -302
;	ERRORLEVEL -306


	    list      p=12F617            ; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


     __CONFIG   _CP_OFF & _BOR_ON & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _IOSCFS_4MHZ & _WRT_OFF


; RAM 

STORE1			equ	H'22'	; delay counter	
STORE2			equ	H'23'	; delay counter
STORE3			equ	H'24'	; delay counter
TEMP			equ	H'25'	; temporary
THERMISTOR	equ	H'26'	; thermistor reading in deg C plus 10 
THRESH1		equ	H'27'	; threshold 1
THRESH1_ls		equ	H'28'	; threshold 1 ls bits
THRESH2		equ	H'29'	; threshold 2
THRESH2_ls		equ	H'2A'	; threshold 2 ls bits
THRSH1_CALC	equ	H'2B'	; threshold 1 calculated to match thermistor format
THRSH2_CALC	equ	H'2C'	; threshold 2 calculated to match thermistor format

; Math registers
TEMPB1      		equ H'62'
TEMPB0      		equ H'63'
TEMPD       		equ H'64'    	; temporary storage
AARGB3		equ	H'65'
AARGB2     		equ H'66'
AARGB1      		equ H'67'
AARGB0     		equ H'68'	; most significant byte of argument A
    
BARGB1    		equ H'69'
BARGB0      		equ H'6A'	; most significant byte of argument B
    
REMB1      		equ H'6B'
REMB0       		equ H'6C'   	; most significant byte of remainder
LOOPCOUNT   	equ H'6D'   	; loop counter

; ******************************************************************

; start at memory 0
	org		0			; reset vector
	goto	MAIN
;_________________________________________________________________________

; Lookup table for ambient temperature
TEMP_CALC
;
; return value is degrees C based on A/D value from  voltage divider with 3.9k pullup resistor to 5V and thermistor to 0V.
; (NTC thermistor is 10k ohms at 25 deg C and with a Beta of 4100)

; temperature is return value minus 10 to give -10 deg C minimum 
; return value is 10 more than the measured degrees C. This is to cater for a -10 degrees reading that returns as 0 (RETLW  0)
	movwf	TEMP
; check if over 240
	sublw	D'240'
	btfss	STATUS,C
	retlw	D'0'			; less than -10 degrees C.

; subtract 17 from w (start at A/D value for 155 degrees C)

	movlw	D'17'
	subwf	TEMP,w
	btfss	STATUS,C	; if clear (ie less than 17) return with D'140' for 130 degrees
	retlw	D'140'		; maximum 130 degrees even if it is more (return value  -10 gives degrees C)

	call    	TABLE
	return

TABLE	
	addwf	PCL,f		; add to program counter
; value returned (retlw) is 10 more (ie 10 degrees C more) as a 100mV reference allows for up to 10 degrees below 0

; 111 to 130 degrees (value returned - 10)
	retlw	D'140'		; for A/D of 17
	retlw	D'137'		; for A/D of 18
	retlw	D'135'		; for A/D of 19
	retlw	D'133'		; for A/D of 20
	retlw	D'131'		; for A/D of 21
	retlw	D'129'		; for A/D of 22
	retlw	D'127'		; for A/D of 23
	retlw	D'125'		; for A/D of 24
	retlw	D'124'		; for A/D of 25
	retlw	D'122'		; for A/D of 26
	retlw	D'121'		; for A/D of 27

; 101 to 110 degrees (value returned - 10)
	retlw	D'119'		; for A/D of 28
	retlw	D'118'		; for A/D of 29
	retlw	D'116'		; for A/D of 30
	retlw	D'115'		; for A/D of 31
	retlw	D'114'		; for A/D of 32
	retlw	D'113'		; for A/D of 33
	retlw	D'111'		; for A/D of 34

; 91 to 100 degrees (value returned - 10)
	retlw	D'110'		; for A/D of 35
	retlw	D'109'		; for A/D of 36
	retlw	D'108'		; for A/D of 37
	retlw	D'107'		; for A/D of 38
	retlw	D'106'		; for A/D of 39
	retlw	D'105'		; for A/D of 40
	retlw	D'104'		; for A/D of 41
	retlw	D'103'		; for A/D of 42
	retlw	D'102'		; for A/D of 43
	retlw	D'101'		; for A/D of 44
	retlw	D'101'		; for A/D of 45

; 81 to 90 degrees (value returned - 10)
	retlw	D'100'		; for A/D of 46
	retlw	D'99'		; for A/D of 47
	retlw	D'98'		; for A/D of 48
	retlw	D'97'		; for A/D of 49
	retlw	D'96'		; for A/D of 50
	retlw	D'96'		; for A/D of 51
	retlw	D'95'		; for A/D of 52
	retlw	D'94'		; for A/D of 53
	retlw	D'93'		; for A/D of 54
	retlw	D'92'		; for A/D of 55
	retlw	D'92'		; for A/D of 56
	retlw	D'91'		; for A/D of 57

; 71 to 80 degrees (value returned - 10)
	retlw	D'90'		; for A/D of 58
	retlw	D'90'		; for A/D of 59
	retlw	D'89'		; for A/D of 60
	retlw	D'88'		; for A/D of 61
	retlw	D'88'		; for A/D of 62
	retlw	D'87'		; for A/D of 63
	retlw	D'86'		; for A/D of 64
	retlw	D'86'		; for A/D of 65
	retlw	D'85'		; for A/D of 66
	retlw	D'85'		; for A/D of 67
	retlw	D'84'		; for A/D of 68
	retlw	D'83'		; for A/D of 69
	retlw	D'83'		; for A/D of 70
	retlw	D'82'		; for A/D of 71
	retlw	D'82'		; for A/D of 72
	retlw	D'81'		; for A/D of 73
	retlw	D'81'		; for A/D of 74

; 61 to 70 degrees (value returned - 10)
	retlw	D'80'		; for A/D of 75
	retlw	D'80'		; for A/D of 76
	retlw	D'79'		; for A/D of 77
	retlw	D'78'		; for A/D of 78
	retlw	D'78'		; for A/D of 79
	retlw	D'77'		; for A/D of 80
	retlw	D'77'		; for A/D of 81
	retlw	D'76'		; for A/D of 82
	retlw	D'76'		; for A/D of 83
	retlw	D'75'		; for A/D of 84
	retlw	D'75'		; for A/D of 85
	retlw	D'74'		; for A/D of 86
	retlw	D'74'		; for A/D of 87
	retlw	D'74'		; for A/D of 88
	retlw	D'73'		; for A/D of 89
	retlw	D'73'		; for A/D of 90
	retlw	D'72'		; for A/D of 91
	retlw	D'72'		; for A/D of 92
	retlw	D'71'		; for A/D of 93
	retlw	D'71'		; for A/D of 94

; 51 to 60 degrees (value returned - 10)
	retlw	D'70'		; for A/D of 95
	retlw	D'70'		; for A/D of 96
	retlw	D'70'		; for A/D of 97
	retlw	D'69'		; for A/D of 98
	retlw	D'68'		; for A/D of 99
	retlw	D'68'		; for A/D of 100
	retlw	D'67'		; for A/D of 101
	retlw	D'67'		; for A/D of 102
	retlw	D'67'		; for A/D of 103
	retlw	D'66'		; for A/D of 104
	retlw	D'66'		; for A/D of 105
	retlw	D'65'		; for A/D of 106
	retlw	D'65'		; for A/D of 107
	retlw	D'64'		; for A/D of 108
	retlw	D'64'		; for A/D of 109
	retlw	D'64'		; for A/D of 110
	retlw	D'63'		; for A/D of 111
	retlw	D'63'		; for A/D of 112
	retlw	D'63'		; for A/D of 113
	retlw	D'63'		; for A/D of 114
	retlw	D'62'		; for A/D of 115
	retlw	D'62'		; for A/D of 116
	retlw	D'61'		; for A/D of 117
	retlw	D'61'		; for A/D of 118
	retlw	D'61'		; for A/D of 119
	
; 41 to 50 degrees (value returned - 10)
	retlw	D'60'		; for A/D of 120
	retlw	D'60'		; for A/D of 121
	retlw	D'60'		; for A/D of 122
	retlw	D'59'		; for A/D of 123
	retlw	D'59'		; for A/D of 124
	retlw	D'59'		; for A/D of 125
	retlw	D'58'		; for A/D of 126
	retlw	D'58'		; for A/D of 127
	retlw	D'57'		; for A/D of 128
	retlw	D'57'		; for A/D of 129
	retlw	D'56'		; for A/D of 130
	retlw	D'56'		; for A/D of 131
	retlw	D'56'		; for A/D of 132
	retlw	D'55'		; for A/D of 133
	retlw	D'55'		; for A/D of 134
	retlw	D'55'		; for A/D of 135
	retlw	D'54'		; for A/D of 136
	retlw	D'54'		; for A/D of 137
	retlw	D'53'		; for A/D of 138
	retlw	D'53'		; for A/D of 139
	retlw	D'53'		; for A/D of 140
	retlw	D'52'		; for A/D of 141
	retlw	D'52'		; for A/D of 142
	retlw	D'51'		; for A/D of 143
	retlw	D'51'		; for A/D of 144

; 31 to 40 degrees (value returned - 10)
	retlw	D'50'		; for A/D of 145
	retlw	D'50'		; for A/D of 146
	retlw	D'50'		; for A/D of 147
	retlw	D'49'		; for A/D of 148
	retlw	D'49'		; for A/D of 149
	retlw	D'49'		; for A/D of 150
	retlw	D'48'		; for A/D of 151
	retlw	D'48'		; for A/D of 152
	retlw	D'47'		; for A/D of 153
	retlw	D'47'		; for A/D of 154
	retlw	D'46'		; for A/D of 155
	retlw	D'46'		; for A/D of 156
	retlw	D'46'		; for A/D of 157
	retlw	D'45'		; for A/D of 158
	retlw	D'45'		; for A/D of 159
	retlw	D'45'		; for A/D of 160
	retlw	D'44'		; for A/D of 161
	retlw	D'44'		; for A/D of 162
	retlw	D'43'		; for A/D of 163
	retlw	D'43'		; for A/D of 164
	retlw	D'43'		; for A/D of 165
	retlw	D'42'		; for A/D of 166
	retlw	D'42'		; for A/D of 167
	retlw	D'41'		; for A/D of 168
	retlw	D'41'		; for A/D of 169

; 21 to 30 degrees (value returned - 10)
	retlw	D'40'		; for A/D of 170
	retlw	D'40'		; for A/D of 171
	retlw	D'40'		; for A/D of 172
	retlw	D'39'		; for A/D of 173
	retlw	D'39'		; for A/D of 174
	retlw	D'39'		; for A/D of 175
	retlw	D'38'		; for A/D of 176
	retlw	D'38'		; for A/D of 177
	retlw	D'38'		; for A/D of 178
	retlw	D'37'		; for A/D of 179
	retlw	D'37'		; for A/D of 180
	retlw	D'36'		; for A/D of 181
	retlw	D'36'		; for A/D of 182
	retlw	D'35'		; for A/D of 183
	retlw	D'35'		; for A/D of 184
	retlw	D'34'		; for A/D of 185
	retlw	D'34'		; for A/D of 186
	retlw	D'33'		; for A/D of 187
	retlw	D'33'		; for A/D of 188
	retlw	D'32'		; for A/D of 189
	retlw	D'32'		; for A/D of 190
	retlw	D'32'		; for A/D of 191
	retlw	D'31'		; for A/D of 192
	retlw	D'31'		; for A/D of 193

; 11 to 20 degrees (value returned - 10)
	retlw	D'30'	        ; for A/D of 194
	retlw	D'30'		; for A/D of 195
	retlw	D'29'		; for A/D of 196
	retlw	D'29'		; for A/D of 197
	retlw	D'28'		; for A/D of 198
	retlw	D'28'		; for A/D of 199
	retlw	D'27'		; for A/D of 200
	retlw	D'27'		; for A/D of 201
	retlw	D'26'		; for A/D of 202
	retlw	D'26'		; for A/D of 203
	retlw	D'25'		; for A/D of 204
	retlw	D'25'		; for A/D of 205
	retlw	D'24'		; for A/D of 206
	retlw	D'24'		; for A/D of 207
	retlw	D'23'		; for A/D of 208
	retlw	D'23'		; for A/D of 209
	retlw	D'22'		; for A/D of 210
	retlw	D'22'		; for A/D of 211
	retlw	D'21'		; for A/D of 212
	retlw	D'21'		; for A/D of 213

; 1 to 10 degrees (value returned - 10)
	retlw	D'20'		; for A/D of 214
	retlw	D'19'		; for A/D of 215
	retlw	D'19'		; for A/D of 216
	retlw	D'18'		; for A/D of 217
	retlw	D'18'		; for A/D of 218
	retlw	D'17'		; for A/D of 219
	retlw	D'17'		; for A/D of 220
	retlw	D'16'		; for A/D of 221
	retlw	D'15'		; for A/D of 222
	retlw	D'15'		; for A/D of 223
	retlw	D'14'		; for A/D of 224
	retlw	D'13'		; for A/D of 225
	retlw	D'12'		; for A/D of 226
	retlw	D'12'		; for A/D of 227
	retlw	D'11'		; for A/D of 228

; -10 to 0 degrees (value returned - 10)
	retlw	D'10'		; for A/D of 229
	retlw	D'10'		; for A/D of 230
	retlw	D'9'			; for A/D of 231
	retlw	D'8'			; for A/D of 232
	retlw	D'7'			; for A/D of 233
	retlw	D'6'			; for A/D of 234
	retlw	D'5'			; for A/D of 235
	retlw	D'4'			; for A/D of 236
	retlw	D'3'			; for A/D of 237
	retlw	D'2'			; for A/D of 238
	retlw	D'1'			; for A/D of 239
	retlw	D'0'			; for A/D of 240
	retlw	D'0'			; for A/D of 241
	retlw	D'0'			; for A/D of 242
	retlw	D'0'			; for A/D of 243

;____________________________________________________________________________


MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
        movlw   0x00      			; set oscillator to factory calibrated frequency 
        movwf   OSCTUNE
	bcf		STATUS,RP0
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'		; pullups off
	movwf	WPU
	movlw	B'00011011'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'10000000'		; settings (pullups disabled) 
	movwf	OPTION_REG
; analog inputs, A/D
	movlw	B'01011011'
	movwf	ANSEL			; digital I/O and analog at AN0,1,3
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000000'		; channel 0, left justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on

; pwm set
	bsf		STATUS,RP0	; select memory bank 1
	movlw	H'FF'
	movwf	PR2				; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	movlw	D'0'				; zero initially
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00000000'		; prescaler /1
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'		; set PWM mode
	movwf	CCP1CON		; enable PWM operation

	clrf		PCLATH

UPDATE
; timer
; add delay for chatter reduction
	movlw	D'50'
	movwf	TEMP
STRT_DEL
	call		DELAYms		; 20ms approx
	decfsz	TEMP,f
	goto	STRT_DEL		; startup delay

; read A/D
; bits 3-2 CHS1:CHS0: Analog Channel Select bits

;00 = Channel 00 (AN0) 
;Thermistor
	bcf		ADCON0,0		; A/D off
	bcf		ADCON0,7		; left justified
	bcf		ADCON0,2		; 
	bcf		ADCON0,3		; channel 0
	bsf		ADCON0,0		; A/D on
	call		DELAYms
	call		ACQUIRE_AD
	movf	ADRESH,w
; ls bits
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	TEMP			; bank 0 store

; increase ADRESH if bit 7 of ADRESL (now in TEMP) is set for rounding up
	btfsc	TEMP,7
	incf		ADRESH,f

; use lookup thermistor table for its temperature
	clrf		PCLATH
	movf	ADRESH,w	
	call		TEMP_CALC	; get temperature
	movwf	THERMISTOR

; calculate a value for test point TP4 that is thermistor temperature as 10mV/degrees C

; set scaling of 0.515 so multiply by 103 and divide by 100 then divide by 2  (shift right to 
; to convert lookup table value to suitable voltage for temperature at PWM output)

	call		MULT_DIV1		; do the multiply and divide
	
	bcf		STATUS,C
	rrf		AARGB2,w
; load upper 8-bits for PWM out

	movwf	CCPR1L

; carry to CCP1CON,5
	btfss	STATUS,C
	goto	CLR5
	bsf		CCP1CON,5
	goto	REMAINDER	
CLR5
	bcf		CCP1CON,5
REMAINDER
; remainder bit  of calculation into bit  4 of CCP1CON
	btfss	REMB0,7
	goto	CLR4
	bsf		CCP1CON,4
	goto	CHANNELS
CLR4
	bcf		CCP1CON,4

CHANNELS
; 01 = Channel 01 (AN1) 
; Threshold 1
	bcf		ADCON0,0		; A/D off
	bsf		ADCON0,7		; right justified
	bsf		ADCON0,2		; channel 1
	bcf		ADCON0,3		; 
	bsf		ADCON0,0		; A/D on
	call		DELAYms
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	THRESH1
; ls bits
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	THRESH1_ls

; 11 = Channel 03 (AN3) 
; Threshold 2
	bcf		ADCON0,0		; A/D off
	bsf		ADCON0,7		; right justified
	bsf		ADCON0,2		; channel 3
	bsf		ADCON0,3		; 
	bsf		ADCON0,0		; A/D on
	call		DELAYms
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	THRESH2
; ls bits
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0	; select memory bank 0
	movwf	THRESH2_ls
;___________________________________________________________________

; calculations
; test points are for 10mV/degrees C. These are a division by 3.4 from what is read by A/D converter so it is 34mV/degrees C
; for 100 degrees it is 1.1V at test point (0.1 is due to the 100mV reference offset and so when x3.4 is 3.74V at A/D input for a digital value of 191).
; so calculation for degrees C from digital value is to divide by 1.734 (ie equivalent to x1000 and divide by 1734)
; also thermistor value is degrees C plus 10 as found in lookup table

; Threshold 1 calculation
THRESH1_CALCULATION
; check if zero	
	movf	THRESH1,w
	btfss	STATUS,Z
	goto	DO_CALCP1
	movf	THRESH1_ls,w
	btfss	STATUS,Z
	goto	DO_CALCP1
; zero
	clrf		AARGB2
	clrf		AARGB1
	clrf		REMB0
	goto	BYP1				; bypass calculation if 0
DO_CALCP1

; place in AARGB0,1
	movf	THRESH1,w			; ms byte
	movwf	AARGB0
	movf	THRESH1_ls,w		; ls byte
	movwf	AARGB1		
	call		MULT_DIV2			; x1000 and /1734

BYP1
; move right for 10-bit to 8-bit
	bcf		STATUS,C
	rrf		AARGB1,f
	rrf		AARGB2,f
	movf	STATUS,w
	movwf	TEMP				; keep carry
	bcf		STATUS,C
	rrf		AARGB1,f
	rrf		AARGB2,f
	btfsc	TEMP,0				; stored carry,  if set increase

; if set, increase AARGB2 to round up
	incf		AARGB2,f
	movf	AARGB2,w
	movwf	THRSH1_CALC

; Threshold 2 calculation
THRESH2_CALCULATION
; check if zero	
	movf	THRESH2,w
	btfss	STATUS,Z
	goto	DO_CALCP2
	movf	THRESH2_ls,w
	btfss	STATUS,Z
	goto	DO_CALCP2
; zero
	clrf		AARGB2
	clrf		AARGB1
	clrf		REMB0
	goto	BYP2				; bypass calculation if 0
DO_CALCP2

; place in AARGB0,1
	movf	THRESH2,w
	movwf	AARGB0

	movf	THRESH2_ls,w
	movwf	AARGB1

	call		MULT_DIV2			; x1000 and /1734
BYP2
; move right for 10-bit to 8-bit
	bcf		STATUS,C
	rrf		AARGB1,f
	rrf		AARGB2,f
	movf	STATUS,w
	movwf	TEMP				; keep carry
	bcf		STATUS,C
	rrf		AARGB1,f
	rrf		AARGB2,f
	btfsc	TEMP,0				; stored carry,  if set increase

; if set, increase AARGB2 to round up
	incf		AARGB2,f
	movf	AARGB2,w
	movwf	THRSH2_CALC

COMPARE

; compare thresholds with thermistor
; if Threshold2>Threshold1 then relay on when thermistor is above Threshold 2 and off when thermistor is below Threshold1	
; if Threshold2<Threshold1 then relay on when thermistor is below Threshold 2 and off when thermistor is above Threshold1

; firstly check thresholds

	movf	THRSH1_CALC,w
	subwf	THRSH2_CALC,w
	btfsc	STATUS,C			; if carry is clear then threshold1>threshold2
	goto	STANDARD			; threshold 2>threshold 1
; relay on when thermistor <threshold2 off when above threshold1
	btfsc	STATUS,Z 			; check if the same
	goto	SAME				; just use one threshold for on and off
;Threshold2<Threshold1 then relay on when thermistor is below Threshold 2 and off when thermistor is above Threshold1

;check if relay is on
	btfsc	GPIO,5
	goto	ON_NON_STANDARD		; just check threshold 1 for when to switch off relay

; check  if thermistor is below threshold 2 to switch on relay	
	movf	THRSH2_CALC,w
	subwf	THERMISTOR,w
	btfss	STATUS,C			; if carry clear then switch on relay
	bsf		GPIO,5
; if the same, switch on relay
	btfsc	STATUS,Z
	bsf		GPIO,5
	goto	UPDATE

ON_NON_STANDARD
; check if Thermistor is above threshold1 to switch off relay
	movf	THERMISTOR,w
	subwf	THRSH1_CALC,w
	btfss	STATUS,C
	bcf		GPIO,5
; if the same, switch off relay
	btfsc	STATUS,Z
	bcf		GPIO,5
	goto	UPDATE

STANDARD
;Threshold2>Threshold1 then relay on when thermistor is above Threshold 2 and off when thermistor is below Threshold1	
	btfsc	STATUS,Z 			; check if the same
	goto	SAME				; just use one threshold for on and off
;check if relay is on
	btfsc	GPIO,5
	goto	ON_STANDARD		; just check threshold 1 for when to switch off relay

; check  if thermistor is above threshold 2 to switch on relay	
	movf	THERMISTOR,w
	subwf	THRSH2_CALC,w
	btfss	STATUS,C			; if carry clear then switch on relay
	bsf		GPIO,5
; if the same, switch on relay
	btfsc	STATUS,Z
	bsf		GPIO,5
	goto	UPDATE

ON_STANDARD
; check if Thermistor is below threshold1 to switch off relay
	movf	THRSH1_CALC,w
	subwf	THERMISTOR,w
	btfss	STATUS,C
	bcf		GPIO,5
; if the same, switch off relay
	btfsc	STATUS,Z
	bcf		GPIO,5
	goto	UPDATE

SAME; both thresholds the same
	movf	THERMISTOR,w
	subwf	THRSH2_CALC,w
	btfss	STATUS,C			; if carry clear then switch on relay
	goto	RLY_ON
	bcf		GPIO,5
	goto	UPDATE

RLY_ON
	bsf		GPIO,5
	goto	UPDATE

; *****************************************************************************************************************************************************
; subroutines

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; delay loop 
; 10.87ms
DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

MULT_DIV1; x 103/100 for 0.515 scaling (requires result shifting right for /2) 
; x 103				
	movwf	AARGB1
	movlw	D'103'
	movwf	BARGB1
	clrf		AARGB0
	clrf		BARGB0
	call		FXM1616U			; value in AARGB0,1,2,3
; shift bytes for 32 bit answer to 24 bit
	movf	AARGB1,w
	movwf	AARGB0
	movf	AARGB2,w
	movwf	AARGB1
	movf	AARGB3,w
	movwf	AARGB2

; /100
	clrf		BARGB0
	movlw	D'100'
	movwf	BARGB1
	call		FXD2416U			; value in AARGB0,1,2
	return

MULT_DIV2; x1000/1734 for divide by 1.734
; x 1000	(H3EB)			
	movlw	H'03'
	movwf	BARGB0
	movlw	H'EB'
	movwf	BARGB1
	call		FXM1616U			; value in AARGB0,1,2,3
; shift bytes for 32 bit answer to 24 bit
	movf	AARGB1,w
	movwf	AARGB0
	movf	AARGB2,w
	movwf	AARGB1
	movf	AARGB3,w
	movwf	AARGB2

; /1734
	movlw	H'06'
	movwf	BARGB0
	movlw	H'C6'
	movwf	BARGB1
	call		FXD2416U			; value in AARGB0,1,2
	return

; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LA 		RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LC 		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L			RETURN
	
; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   H'00'
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  H'08'
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
                RETURN



	end
